# * Copyright (C) 2020 Texas Instruments Incorporated - http://www.ti.com/
#  *
#  *
#  *  Redistribution and use in source and binary forms, with or without
#  *  modification, are permitted provided that the following conditions
#  *  are met:
#  *
#  *    Redistributions of source code must retain the above copyright
#  *    notice, this list of conditions and the following disclaimer.
#  *
#  *    Redistributions in binary form must reproduce the above copyright
#  *    notice, this list of conditions and the following disclaimer in the
#  *    documentation and/or other materials provided with the
#  *    distribution.
#  *
#  *    Neither the name of Texas Instruments Incorporated nor the names of
#  *    its contributors may be used to endorse or promote products derived
#  *    from this software without specific prior written permission.
#  *
#  *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#  *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#  *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#  *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#  *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#  *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#  *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#  *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#  *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#  *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#  *
# */


from Menu_Info import *
from Read_Info import *
from Input_Info import *
from Write_Info import *
from Output_Info import *
from tkinter import *
import tkinter as tk
from tkinter.ttk import *
import os, sys

def resource_path(relative_path):
    if hasattr(sys, '_MEIPASS'):
        return os.path.join(sys._MEIPASS, relative_path)
    return os.path.join(os.path.abspath("."), relative_path)


class Application:
    def __init__(self):
        # Create the main window and format it
        self.root = Tk()
        self.root.title('TI Zigbee Network Properties Cloning Tool ')
        self.root.configure(bg='white')
        if sys.platform.startswith('darwin'):
            self.root.geometry("872x520")
            style = ttk.Style()
            style.theme_use('default')
        else:
            self.root.geometry("875x540")

        # Locate the window within the screen
        window_width = self.root.winfo_reqwidth()
        window_height = self.root.winfo_reqheight()
        position_right = int(self.root.winfo_screenwidth() / 2 - window_width / 2) - 300
        position_down = int(self.root.winfo_screenheight() / 2 - window_height / 2) - 200
        self.root.geometry("+{}+{}".format(position_right, position_down))
        self.root.resizable(width=False, height=False)

        # Change the icon of the window
        # self.root.iconbitmap('ti-logo.ico')
        # self.root.grid()
        # Change the icon of the window
        img_icon = PhotoImage(file=resource_path("ti_logo.png"))
        self.root.tk.call('wm', 'iconphoto', self.root._w, img_icon)

        # Call to create the widgets
        self.create_widgets()

    def start_application(self):
        # Start Monitoring and Updating the GUI
        self.root.mainloop()
        return

    def create_widgets(self):
        # Call all of the other functions that create widgets
        output_settings(self.root)
        input_settings(self.root, True)
        read_settings(self.root)
        write_settings(self.root)
        menu_settings(self.root)
        return
